#Handle movement inputs from "controller"
execute as @a[tag=controller] run function astro_game:spaceship/process_controls

#Handle shooting inputs from "controller"
execute as @e[tag=turret_input_box] run function astro_game:spaceship/actions/turret/process_input

#Handle turret (apply rotation, offset and calls for target handling)
execute as @e[tag=spaceship_turret] run function astro_game:spaceship/actions/spaceship/handle_turret


#Handle obstacles movement
function astro_game:obstacles/tick

#Handle projectiles
execute as @e[tag=projectile] run function astro_game:spaceship/actions/turret/projectile/update

#Update powerups
function astro_game:spaceship/actions/spaceship/powerups/update


#Handle collisions
execute positioned as @e[tag=spaceship_body,limit=1] positioned ~ ~ ~-0.5 as @e[distance=0..2,tag=obstacle] run function astro_game:spaceship/actions/spaceship/handle_collisions

#Handle score display
title @a[tag=game_viewer] actionbar [{text:"[",font:"large",type:"text"},{font:"default",translate:"space.-46",type:"translatable"},{score:{name:"score",objective:"astro_game.score"},font:"large",type:"score"},{font:"default",translate:"space.-26",type:"translatable"},{text:"]",font:"large",type:"text"},{font:"default",translate:"space.-6",type:"translatable"},{text:"f",font:"small",type:"text"},{score:{name:"bonus_buffer",objective:"astro_game.score"},font:"small",type:"score"},{font:"default",translate:"space.-26",type:"translatable"},{text:"]",font:"large",type:"text"},{font:"default",translate:"space.1",type:"translatable"},{score:{name:"energy_output",objective:"astro_game.turret"},font:"stamina",type:"score"},{score:{name:"recharge_output",objective:"astro_game.turret"},font:"recharge",type:"score"},{score:{name:"arrow_highlight",objective:"astro_game.tutorial"},font:"stamina_tutorial",type:"score"}]